;;   Il est difficile de prvoir l'efficacit d'un rseau. L'augmentation du
;; nombre de couches n'est pas forcment rentable...
;;   Un rseau  deux couches avec un nombre suffisant d'units *hidden* est en
;; principe la meilleure solution pour des fonctions boolennes du type des
;; exemples ci-dessous [cf. Mitchell, p. 105].

;[Cf. MITCHELL, ex. 4.7, p. 125]
(cree-reseau-MCU qsd 2 (unite-sig 1) (unite-sig 1) :nu 0.3 :Accel 0.9)
(Couches? qsd)
(setf (slot-value usXXX 'Ws) '(0.1 0.1 0.1))                ;<--  complter...
(setf (slot-value usXXX 'Ws) '(0.1 0.1))                    ;<--  complter...
(performe qsd '( ((1 0) (1))
                 ((0 1) (0))
               ) :print t)

(corrige  qsd '(1 0) '(1))(corrige  qsd '(0 1) '(0))

(apprend  qsd '( ((1 0) (1))                                ;62 tapes, par ex.
                 ((0 1) (0))))

;--------------------

;[Cf. MITCHELL, exemple, pp. 106-107]
(cree-reseau-MCU idnt8 8 (unite-sig 3) (unite-sig 8) :nu 0.1 :Accel 0.5)
(performe idnt8 '( ((1 0 0 0 0 0 0 0) (1 0 0 0 0 0 0 0))
                   ((0 1 0 0 0 0 0 0) (0 1 0 0 0 0 0 0))
                   ((0 0 1 0 0 0 0 0) (0 0 1 0 0 0 0 0))
                   ((0 0 0 1 0 0 0 0) (0 0 0 1 0 0 0 0))
                   ((0 0 0 0 1 0 0 0) (0 0 0 0 1 0 0 0))
                   ((0 0 0 0 0 1 0 0) (0 0 0 0 0 1 0 0))
                   ((0 0 0 0 0 0 1 0) (0 0 0 0 0 0 1 0))
                   ((0 0 0 0 0 0 0 1) (0 0 0 0 0 0 0 1))
                  ) :print t)
(apprend  idnt8 '( ((1 0 0 0 0 0 0 0) (1 0 0 0 0 0 0 0))  ;1413 tapes, par ex.
                   ((0 1 0 0 0 0 0 0) (0 1 0 0 0 0 0 0))
                   ((0 0 1 0 0 0 0 0) (0 0 1 0 0 0 0 0))
                   ((0 0 0 1 0 0 0 0) (0 0 0 1 0 0 0 0))
                   ((0 0 0 0 1 0 0 0) (0 0 0 0 1 0 0 0))
                   ((0 0 0 0 0 1 0 0) (0 0 0 0 0 1 0 0))
                   ((0 0 0 0 0 0 1 0) (0 0 0 0 0 0 1 0))
                   ((0 0 0 0 0 0 0 1) (0 0 0 0 0 0 0 1))))
;Impression des sortie de l'tage *hidden*
(Couches? idnt8)
(let ((h1 us220) (h2 us221) (h3 us222)                       ;<--  modifier...
       o1 o2 o3 r1 r2 r3)
  (format t "~&")
  (dolist (Ins '((1 0 0 0 0 0 0 0)(0 1 0 0 0 0 0 0)(0 0 1 0 0 0 0 0)
                 (0 0 0 1 0 0 0 0)(0 0 0 0 1 0 0 0)(0 0 0 0 0 1 0 0)
                 (0 0 0 0 0 0 1 0)(0 0 0 0 0 0 0 1)))
    (tire idnt8 Ins) (format t "---~A~%" Ins)
    (setq o1 (Out? h1)) (setq o2 (Out? h2)) (setq o3 (Out? h3))
    (setq r1 (round o1))(setq r2 (round o2))(setq r3 (round o3))
    (format t "~F20 ~F20 ~F20~%" o1 o2 o3)
    (format t "~D~21T~D~42T~D~%" r1 r2 r3)))
;??????????????????????????????????????????????
;Tests de tolrance maximale de idnt8,  0.1 prs
(performe idnt8 '( ((1 .05 .05 .05 .05 .05 .05 .05) (1 0 0 0 0 0 0 0))
                   ((0 1 0 0 0 0 0 0) (0 1 0 0 0 0 0 0))
                   ((0 0 1 0 0 0 0 0) (0 0 1 0 0 0 0 0))
                   ((0 0 0 1 0 0 0 0) (0 0 0 1 0 0 0 0))
                   ((0 0 0 0 1 0 0 0) (0 0 0 0 1 0 0 0))
                   ((0 0 0 0 0 1 0 0) (0 0 0 0 0 1 0 0))
                   ((0 0 0 0 0 0 1 0) (0 0 0 0 0 0 1 0))
                   ((0 0 0 0 0 0 0 1) (0 0 0 0 0 0 0 1))
                  ) :print t)

;--------------------

;Arbitraire
(cree-reseau-MCU azer 4 (unite-sig 3) (unite-sig 2) :nu 0.15 :Accel 0.5)
(performe azer '( ((0  0  0  1) (1  0))
                  ((0  0  1  1) (0  0))
                  ((0  1  0  0) (0  0))
                  ((0  1  0  1) (0  0))
                  ((1  0  0  0) (0  1))
                  ((1  0  1  0) (1  0))
                  ((1  1  1  0) (0  1))
                  ) :print t)
(memorable? azer '( ((0  0  0  1) (1  0))
                    ((0  0  1  1) (0  0))
                    ((0  1  0  0) (0  0))
                    ((0  1  0  1) (0  0))
                    ((1  0  0  0) (0  1))
                    ((1  0  1  0) (1  0))
                    ((1  1  1  0) (0  1))))
(apprend azer    '( ((0  0  0  1) (1  0))                 ;474 tapes, par ex.
                    ((0  0  1  1) (0  0))
                    ((0  1  0  0) (0  0))
                    ((0  1  0  1) (0  0))
                    ((1  0  0  0) (0  1))
                    ((1  0  1  0) (1  0))
                    ((1  1  1  0) (0  1))))

;--------------------

;Cf. ann.01c.seance.cl
(cree-reseau-MCU XOR 2 (unite-sig 2) (unite-sig 1) :nu 0.1 :Accel 0.5)
(performe XOR '( ((0  0) (0))
                 ((0  1) (1))
                 ((1  0) (1))
                 ((1  1) (0))
                ) :print t)
(apprend  XOR '( ((0  0) (0))                             ;9600 tapes, par ex.
                 ((0  1) (1))
                 ((1  0) (1))
                 ((1  1) (0))))

;Le mme, avec 1 unit *hidden* supplmentaire : pas plus efficace
(cree-reseau-MCU XORa 2 (unite-sig 3) (unite-sig 1) :nu 0.1 :Accel 0.5)
(performe XORa '( ((0  0) (0))
                  ((0  1) (1))
                  ((1  0) (1))
                  ((1  1) (0))
                 ) :print t)
(apprend  XORa '( ((0  0) (0))                            ;9318 tapes, par ex.
                  ((0  1) (1))
                  ((1  0) (1))
                  ((1  1) (0))))

;Le mme, avec 2 units *hidden* supplmentaires : pas plus efficace
(cree-reseau-MCU XORb 2 (unite-sig 4) (unite-sig 1) :nu 0.1 :Accel 0.5)
(performe XORb '( ((0  0) (0))
                  ((0  1) (1))
                  ((1  0) (1))
                  ((1  1) (0))
                 ) :print t)
(apprend  XORb '( ((0  0) (0))                            ;9187 tapes, par ex.
                  ((0  1) (1))
                  ((1  0) (1))
                  ((1  1) (0))))

;--------------------

(cree-reseau-MCU XOR1 3 (unite-sig 2) (unite-sig 1) :nu 0.1 :Accel 0.5)
(performe XOR1 '( ((0  0  0) (0))
                  ((0  0  1) (1))
                  ((0  1  0) (1))
                  ((0  1  1) (0))
                  ((1  0  0) (1))
                  ((1  0  1) (0))
                  ((1  1  0) (0))
                  ((1  1  1) (0))
                 ) :print t)
(apprend  XOR1 '( ((0  0  0) (0))          ;16218 tapes, env. 12 sec., par ex.
                  ((0  0  1) (1))
                  ((0  1  0) (1))
                  ((0  1  1) (0))
                  ((1  0  0) (1))
                  ((1  0  1) (0))
                  ((1  1  0) (0))
                  ((1  1  1) (0))))

;Essai  3 couches du mme
(cree-reseau-MCU XOR2 3 (unite-sig 2) (unite-sig 1) (unite-sig 1))
(performe XOR2 '( ((0  0  0) (0))
                  ((0  0  1) (1))
                  ((0  1  0) (1))
                  ((0  1  1) (0))
                  ((1  0  0) (1))
                  ((1  0  1) (0))
                  ((1  1  0) (0))
                  ((1  1  1) (0))
                  ) :print t)
(apprend  XOR2 '( ((0  0  0) (0))                ;1099446 tapes, 0h31, par ex.
                  ((0  0  1) (1))
                  ((0  1  0) (1))
                  ((0  1  1) (0))
                  ((1  0  0) (1))
                  ((1  0  1) (0))
                  ((1  1  0) (0))
                  ((1  1  1) (0))))

;Autre essai  3 couches du mme
(cree-reseau-MCU XOR2a 3 (unite-sig 3) (unite-sig 2) (unite-sig 1))
(performe XOR2a '( ((0  0  0) (0))
                   ((0  0  1) (1))
                   ((0  1  0) (1))
                   ((0  1  1) (0))
                   ((1  0  0) (1))
                   ((1  0  1) (0))
                   ((1  1  0) (0))
                   ((1  1  1) (0))
                   ) :print t)
(apprend  XOR2a '( ((0  0  0) (0))                 ;756309 tapes, 0h37 par ex.
                   ((0  0  1) (1))
                   ((0  1  0) (1))
                   ((0  1  1) (0))
                   ((1  0  0) (1))
                   ((1  0  1) (0))
                   ((1  1  0) (0))
                   ((1  1  1) (0))))

;--------------------

;Essai  3 couches : russite, mais pitre performance...
(cree-reseau-MCU XOR3 3 (unite-sig 2) (unite-sig 2) (unite-sig 2))
(performe XOR3 '( ((0  0  0) (0 0))
                  ((0  0  1) (1 0))
                  ((0  1  0) (1 0))
                  ((0  1  1) (0 1))
                  ((1  0  0) (1 0))
                  ((1  0  1) (0 1))
                  ((1  1  0) (0 1))
                  ((1  1  1) (0 1))
                 ) :print t)
(apprend  XOR3 '( ((0  0  0) (0 0))        ;15983 tapes, env. 25 sec., par ex.
                  ((0  0  1) (1 0))
                  ((0  1  0) (1 0))
                  ((0  1  1) (0 1))
                  ((1  0  0) (1 0))
                  ((1  0  1) (0 1))
                  ((1  1  0) (0 1))
                  ((1  1  1) (0 1))))

;Le mme  2 couches : beaucoup plus performant
(cree-reseau-MCU XOR4 3 (unite-sig 2) (unite-sig 2))
(performe XOR4 '( ((0  0  0) (0 0))
                  ((0  0  1) (1 0))
                  ((0  1  0) (1 0))
                  ((0  1  1) (0 1))
                  ((1  0  0) (1 0))
                  ((1  0  1) (0 1))
                  ((1  1  0) (0 1))
                  ((1  1  1) (0 1))
                 ) :print t)
(apprend  XOR4 '( ((0  0  0) (0 0))          ;2788 tapes, env. 3 sec., par ex.
                  ((0  0  1) (1 0))
                  ((0  1  0) (1 0))
                  ((0  1  1) (0 1))
                  ((1  0  0) (1 0))
                  ((1  0  1) (0 1))
                  ((1  1  0) (0 1))
                  ((1  1  1) (0 1))))

;--------------------

(cree-reseau-MCU NXOR 2 (unite-sig 2) (unite-sig 1) :nu 0.1 :Accel 0.5)
(performe NXOR '( ((0  0) (1))
                  ((0  1) (0))
                  ((1  0) (0))
                  ((1  1) (1))
                ) :print t)
(apprend  NXOR '( ((0  0) (1))                           ;13357 tapes, par ex.
                  ((0  1) (0))
                  ((1  0) (0))
                  ((1  1) (1))))

;Le mme, avec une unit *hidden* supplmentaire : plus efficace
(cree-reseau-MCU NXOR1 2 (unite-sig 3) (unite-sig 1) :nu 0.1 :Accel 0.5)
(performe NXOR1 '( ((0  0) (1))
                   ((0  1) (0))
                   ((1  0) (0))
                   ((1  1) (1))
                 ) :print t)
(apprend  NXOR1 '( ((0  0) (1))                           ;8293 tapes, par ex.
                   ((0  1) (0))
                   ((1  0) (0))
                   ((1  1) (1))))

;--------------------

;Cf. ann.01c.seance.cl
(cree-reseau-MCU rARB1 3 (unite-sig 2) (unite-sig 1) :nu 0.1 :Accel 0.4)
(performe rARB1 '( ((0  0  0) (0))
                   ((0  0  1) (1))
                   ((0  1  0) (0))
                   ((0  1  1) (1))
                   ((1  0  0) (0))
                   ((1  0  1) (0))
                   ((1  1  0) (1))
                   ((1  1  1) (1))
                   ) :print t)
(apprend  rARB1 '( ((0  0  0) (0))                       ;10013 tapes, par ex.
                   ((0  0  1) (1))
                   ((0  1  0) (0))
                   ((0  1  1) (1))
                   ((1  0  0) (0))
                   ((1  0  1) (0))
                   ((1  1  0) (1))
                   ((1  1  1) (1))))

;--------------------

;Cf. ann.01c.seance.cl
(cree-reseau-MCU rARB2 4 (unite-sig 3) (unite-sig 1) :nu 0.1 :Accel 0.4)
(performe rARB2 '( ((0  0  0  0)  (0))
                   ((0  0  0  1)  (0))
                   ((0  0  1  0)  (1))
                   ((0  0  1  1)  (0))
                   ((0  1  0  0)  (1))
                   ((0  1  0  1)  (1))
                   ((0  1  1  0)  (1))
                   ((0  1  1  1)  (1))
                   ((1  0  0  0)  (0))
                   ((1  0  0  1)  (1))
                   ((1  0  1  0)  (0))
                   ((1  0  1  1)  (0))
                   ((1  1  0  0)  (1))
                   ((1  1  0  1)  (1))
                   ((1  1  1  0)  (0))
                   ((1  1  1  1)  (1))
                  ) :print t)
(apprend rARB2  '( ((0  0  0  0)  (0))                   ;24355 tapes, par ex.
                   ((0  0  0  1)  (0))
                   ((0  0  1  0)  (1))
                   ((0  0  1  1)  (0))
                   ((0  1  0  0)  (1))
                   ((0  1  0  1)  (1))
                   ((0  1  1  0)  (1))
                   ((0  1  1  1)  (1))
                   ((1  0  0  0)  (0))
                   ((1  0  0  1)  (1))
                   ((1  0  1  0)  (0))
                   ((1  0  1  1)  (0))
                   ((1  1  0  0)  (1))
                   ((1  1  0  1)  (1))
                   ((1  1  1  0)  (0))
                   ((1  1  1  1)  (1))))

;--------------------

;Essai  3 couches
(cree-reseau-MCU rARB3 5 (unite-sig 5) (unite-sig 2) (unite-sig 3) :nu 0.15 :Accel 0.3)
(performe rARB3 '( ((0  0  0  0  0)  (0 0 1))
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))
                  ) :print t)
(apprend rARB3  '( ((0  0  0  0  0)  (0 0 1))         ;ne dpasse pas 15/16
                   ((0  0  0  0  1)  (0 1 0))         ;aprs 0h40 : nu et Accel
                   ((0  0  0  1  0)  (1 0 0))         ;trop lvs (?)
                   ((0  0  0  1  1)  (0 1 1))         ;cf. aussi le suivant
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))))

;Le mme avec nu et Accel plus fins : valeurs par dfaut (0.05 et 0.1 resp.)
(cree-reseau-MCU rARB3a 5 (unite-sig 5) (unite-sig 2) (unite-sig 3))
(performe rARB3a '( ((0  0  0  0  0)  (0 0 1))
                    ((0  0  0  0  1)  (0 1 0))
                    ((0  0  0  1  0)  (1 0 0))
                    ((0  0  0  1  1)  (0 1 1))
                    ((0  0  1  0  0)  (1 0 1))
                    ((0  0  1  0  1)  (1 1 1))
                    ((0  0  1  1  0)  (1 1 0))
                    ((0  0  1  1  1)  (1 0 0))
                    ((1  1  0  0  0)  (0 0 0))
                    ((1  1  0  0  1)  (1 0 1))
                    ((1  1  0  1  0)  (0 0 1))
                    ((1  1  0  1  1)  (0 1 0))
                    ((1  1  1  0  0)  (1 1 1))
                    ((1  1  1  0  1)  (1 1 0))
                    ((1  1  1  1  0)  (0 1 0))
                    ((1  1  1  1  1)  (1 0 1))
                    ) :print t)
(apprend rARB3a  '( ((0  0  0  0  0)  (0 0 1))         ;ne dpasse pas 12/16
                    ((0  0  0  0  1)  (0 1 0))         ;aprs 1h05 : goulot
                    ((0  0  0  1  0)  (1 0 0))         ;d'tranglement au
                    ((0  0  0  1  1)  (0 1 1))         ;second niveau cach (?)
                    ((0  0  1  0  0)  (1 0 1))
                    ((0  0  1  0  1)  (1 1 1))
                    ((0  0  1  1  0)  (1 1 0))
                    ((0  0  1  1  1)  (1 0 0))
                    ((1  1  0  0  0)  (0 0 0))
                    ((1  1  0  0  1)  (1 0 1))
                    ((1  1  0  1  0)  (0 0 1))
                    ((1  1  0  1  1)  (0 1 0))
                    ((1  1  1  0  0)  (1 1 1))
                    ((1  1  1  0  1)  (1 1 0))
                    ((1  1  1  1  0)  (0 1 0))
                    ((1  1  1  1  1)  (1 0 1))))

;Autre essai  3 couches du mme : OK avec plus d'units au second niveau cach
(cree-reseau-MCU rARB3b 5 (unite-sig 5) (unite-sig 4) (unite-sig 3))
(performe rARB3b '( ((0  0  0  0  0)  (0 0 1))
                    ((0  0  0  0  1)  (0 1 0))
                    ((0  0  0  1  0)  (1 0 0))
                    ((0  0  0  1  1)  (0 1 1))
                    ((0  0  1  0  0)  (1 0 1))
                    ((0  0  1  0  1)  (1 1 1))
                    ((0  0  1  1  0)  (1 1 0))
                    ((0  0  1  1  1)  (1 0 0))
                    ((1  1  0  0  0)  (0 0 0))
                    ((1  1  0  0  1)  (1 0 1))
                    ((1  1  0  1  0)  (0 0 1))
                    ((1  1  0  1  1)  (0 1 0))
                    ((1  1  1  0  0)  (1 1 1))
                    ((1  1  1  0  1)  (1 1 0))
                    ((1  1  1  1  0)  (0 1 0))
                    ((1  1  1  1  1)  (1 0 1))
                    ) :print t)
(apprend rARB3b  '( ((0  0  0  0  0)  (0 0 1))   ;72824 tapes, 12 min., par ex.
                    ((0  0  0  0  1)  (0 1 0))
                    ((0  0  0  1  0)  (1 0 0))
                    ((0  0  0  1  1)  (0 1 1))
                    ((0  0  1  0  0)  (1 0 1))
                    ((0  0  1  0  1)  (1 1 1))
                    ((0  0  1  1  0)  (1 1 0))
                    ((0  0  1  1  1)  (1 0 0))
                    ((1  1  0  0  0)  (0 0 0))
                    ((1  1  0  0  1)  (1 0 1))
                    ((1  1  0  1  0)  (0 0 1))
                    ((1  1  0  1  1)  (0 1 0))
                    ((1  1  1  0  0)  (1 1 1))
                    ((1  1  1  0  1)  (1 1 0))
                    ((1  1  1  1  0)  (0 1 0))
                    ((1  1  1  1  1)  (1 0 1))))

;Le mme avec davantage d'units
(cree-reseau-MCU rARB4 5 (unite-sig 6) (unite-sig 4) (unite-sig 3) :Accel 0.15)
(performe rARB4 '( ((0  0  0  0  0)  (0 0 1))
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))
                  ) :print t)
(apprend rARB4  '( ((0  0  0  0  0)  (0 0 1))     ;19919 tapes, 7min., par ex.
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))))

;Le mme avec encore davantage d'units : peu efficace
(cree-reseau-MCU rARB5 5 (unite-sig 8) (unite-sig 5) (unite-sig 3) :Accel 0.15)
(performe rARB5 '( ((0  0  0  0  0)  (0 0 1))
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))
                  ) :print t)
(apprend rARB5  '( ((0  0  0  0  0)  (0 0 1))            ;55081 tapes, par ex.
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))))

;Le mme  2 couches : relativement trs performant
(cree-reseau-MCU rARB6 5 (unite-sig 6) (unite-sig 3))
(performe rARB6 '( ((0  0  0  0  0)  (0 0 1))
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))
                  ) :print t)
(apprend rARB6  '( ((0  0  0  0  0)  (0 0 1))             ;5574 tapes, par ex.
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))))

;Le mme  2 couches avec 2 *hiddens* de moins : apprentissage plus long, mais
;finalement plus efficace
(cree-reseau-MCU rARB7 5 (unite-sig 4) (unite-sig 3))
(performe rARB7 '( ((0  0  0  0  0)  (0 0 1))
                   ((0  0  0  0  1)  (0 1 0))
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))
                  ) :print t)
(apprend rARB7  '( ((0  0  0  0  0)  (0 0 1))     ; 20219 tapes, par ex.
                   ((0  0  0  0  1)  (0 1 0))     ;109219 tapes, 8 min. par ex.
                   ((0  0  0  1  0)  (1 0 0))
                   ((0  0  0  1  1)  (0 1 1))
                   ((0  0  1  0  0)  (1 0 1))
                   ((0  0  1  0  1)  (1 1 1))
                   ((0  0  1  1  0)  (1 1 0))
                   ((0  0  1  1  1)  (1 0 0))
                   ((1  1  0  0  0)  (0 0 0))
                   ((1  1  0  0  1)  (1 0 1))
                   ((1  1  0  1  0)  (0 0 1))
                   ((1  1  0  1  1)  (0 1 0))
                   ((1  1  1  0  0)  (1 1 1))
                   ((1  1  1  0  1)  (1 1 0))
                   ((1  1  1  1  0)  (0 1 0))
                   ((1  1  1  1  1)  (1 0 1))))
;Essais de tolrance empiriques  1% prs
(performe rARB7 '( ((.15 .15 .15 .15 .15)  (0 0 1))
                   ((.05 .05 .02 .03 .97)  (0 1 0)) ;peu tolrant
                   ((.03 .01 .05 .98 .01)  (1 0 0)) ;trs peu tolrant
                   ((.45 .45 .45 .55 .55)  (0 1 1)) ;extrmement tolrant
                   ((.05 .05 .95 .10 .10)  (1 0 1))
                   ((.05 .05 .95 .05 .95)  (1 1 1))
                   ((.25 .25 .70 .80 .25)  (1 1 0)) ;trs tolrant
                   ((.10 .05 .95 .95 .85)  (1 0 0))
                   ((.85 .85 .15 .15 .15)  (0 0 0))
                   ((.99 1.0 .01 .01 .99)  (1 0 1)) ;extrmement peu tolrant
                   ((.85 .80 .15 .85 .15)  (0 0 1))
                   ((.75 .73 .20 .72 .68)  (0 1 0)) ;trs tolrant
                   ((.60 .65 .70 .22 .20)  (1 1 1))
                   ((.90 .85 .90 .05 .85)  (1 1 0))
                   ((.90 .85 .90 .88 .05)  (0 1 0))
                   ((.95 .95 .96 .95 .95)  (1 0 1)) ;peu tolrant
                  ) :print t)
