;;   Les fichiers ann.01.CLOS, puis ann.02.CLOS et ann.03.CLOS doivent avoir t
;; chargs pralablement.

;;   Charger ce fichier, puis valuer manuellement parmi les dernires lignes...

;;   Dfinition de trois instances d'units sigmodes, destines  reproduire
;; deux oprations logiques de base, l'une *linairement sparables* et l'autre
;; non (XOR), ainsi qu'un comportement arbitraire.

(setq sAND  (make-instance 'unite-sig :nom "sAND"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))
(setq sXOR  (make-instance 'unite-sig :nom "sXOR"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))
(setq sARB2 (make-instance 'unite-sig :nom "sARB2"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 5)
                                      :nu  0.005))

;;   Impression des performances des units sigmodes aux diverses
;; combinaisons possibles de stimuli. L'objectif est cit aprs chaque
;; combinaison de stimuli. Leurs pondrations initiales tant alatoires, les
;; units sigmodes ne peuvent pas donner satisfaction ds leur cration...

;;   Les units sigmodes se prtent mieux  une logique boolenne 0/1, plutt
;; que -1/1, bien que ces dernires valeurs puissent aussi tre utilises.

(performe sAND        '((( 0  0)  0)
                        (( 0  1)  0)
                        (( 1  0)  0)
                        (( 1  1)  1)) :print t)
(performe sXOR        '((( 0  0)  0)
                        (( 0  1)  1)
                        (( 1  0)  1)
                        (( 1  1)  0)) :print t)
(performe sARB2 '((( 0  0  0  0)  0)
                  (( 0  0  0  1)  0)
                  (( 0  0  1  0)  1)
                  (( 0  0  1  1)  0)
                  (( 0  1  0  0)  1)
                  (( 0  1  0  1)  1)
                  (( 0  1  1  0)  1)
                  (( 0  1  1  1)  1)
                  (( 1  0  0  0)  0)
                  (( 1  0  0  1)  1)
                  (( 1  0  1  0)  0)
                  (( 1  0  1  1)  0)
                  (( 1  1  0  0)  1)
                  (( 1  1  0  1)  1)
                  (( 1  1  1  0)  0)
                  (( 1  1  1  1)  1)) :print t)

;;   Evaluer manuellement parmi les formes ci-dessous, au besoin...

;(Ws? sAND) (Ws? sXOR) (Ws? sARB2)

;(simplifie sAND (tire sAND  '( 0  0))) (simplifie sAND (tire sAND  '( 0  1)))
;  (simplifie sAND (tire sAND  '( 1  0))) (simplifie sAND (tire sAND  '( 1  1)))
;(simplifie sXOR (tire sXOR '( 0  0))) (simplifie sXOR (tire sXOR '( 0  1)))
;  (simplifie sXOR (tire sXOR '( 1  0))) (simplifie sXOR (tire sXOR '( 1  1)))
;(simplifie sARB2 (tire sARB2 '( 0  0  1  0))) (simplifie sARB2 (tire sARB2 '( 0  1  1  0)))
;  (simplifie sARB2 (tire sARB2 '( 1  1  1  0))) (simplifie sARB2 (tire sARB2 '( 0  1   0  1)))

;;   Demander poliment aux units sigmodes de faire leur apprentissage... On
;; peut choisir l'une et/ou l'autre des deux mthodes d'apprentissage,
;; d'interrompre et reprendre, etc.

;Gradient Descent
;(apprendGD sAND  '((( 0  0)  0) (( 0  1)  0) (( 1  0)  0) (( 1  1)  1)))
;(apprendGD sXOR  '((( 0  0)  0) (( 0  1)  1) (( 1  0)  1) (( 1  1)  0)))
;(apprendGD sARB2 '((( 0  0  0  0)  0) (( 0  0  0  1)  0) (( 0  0  1  0)  1) (( 0  0  1  1)  0) (( 0  1  0  0)  1) (( 0  1  0  1)  1) (( 0  1  1  0)  1) (( 0  1  1  1)  1) (( 1  0  0  0)  0) (( 1  0  0  1)  1) (( 1  0  1  0)  0) (( 1  0  1  1)  0) (( 1  1  0  0)  1) (( 1  1  0  1)  1) (( 1  1  1  0)  0) (( 1  1  1  1)  1)))

;Delta Rule (Stochastic Approximation)
;(apprend sAND  '((( 0  0)  0) (( 0  1)  0) (( 1  0)  0) (( 1  1)  1)))
;(apprend sXOR  '((( 0  0)  0) (( 0  1)  1) (( 1  0)  1) (( 1  1)  0)))
;(apprend sARB2 '((( 0  0  0  0)  0) (( 0  0  0  1)  0) (( 0  0  1  0)  1) (( 0  0  1  1)  0) (( 0  1  0  0)  1) (( 0  1  0  1)  1) (( 0  1  1  0)  1) (( 0  1  1  1)  1) (( 1  0  0  0)  0) (( 1  0  0  1)  1) (( 1  0  1  0)  0) (( 1  0  1  1)  0) (( 1  1  0  0)  1) (( 1  1  0  1)  1) (( 1  1  1  0)  0) (( 1  1  1  1)  1)))

;;   Rvaluer ensuite les mthodes performe d'impression ci-dessus...

;;   Les units sigmodes seront incapables de reproduire parfaitement tous les
;; exemples des comportements non *linairement sparables* : dans ces cas,
;; l'apprentissage ne se terminera jamais... Isoles, et dans la mesure o l'on
;; simplifie les rsultats, les units sigmodes se comportent exactement comme
;; des perceptrons ou des units linaires.

;;   La mthode meilleure-performance permettra cependant de restituer la
;; meilleure performance obtenue en cours d'apprentissage...
;;   Il s'agit en fait des premires pondrations ayant permis d'obtenir le
;; meilleur nombre de ractions correctes, parfois suprieur, mais pas
;; ncessairement,  celui ralis au moment de l'interruption de
;; l'apprentissage.

;(Ws? sAND)       (Ws? sXOR)       (Ws? sARB2)
;(bestPerf? sAND) (bestPerf? sXOR) (bestPerf? sARB2)
;(bestWs?   sAND) (bestWs?   sXOR) (bestWs?   sARB2)

;(meilleure-performance sAND) (meilleure-performance sXOR)
;  (meilleure-performance sARB2)
