;;   Le fichier ann.01.CLOS doit avoir t charg pralablement.

;;; Exemples d'instances  deux, trois et quatre stimuli, constituant des cas
;;; NON *linairement sparable*, donc hors de la porte d'apprentissage de
;;; perceptrons

;;   Charger ce fichier, puis valuer manuellement parmi les dernires lignes...

;;   Dfinition d'une instance de perceptron  deux stimuli, destine 
;; reproduire l'opration logique lmentaire XOR (OU exclusif).

(setq pXOR  (make-instance 'perceptron :nom "pXOR"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 3)))

;;   Dfinition de deux instances de perceptron  trois et quatre stimuli,
;; destines  produire des comportement arbitraires.

(setq pARB1 (make-instance 'perceptron :nom "pARB1"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 4)))
(setq pARB2 (make-instance 'perceptron :nom "pARB2"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 5)))

;;   Impression des performances des perceptrons aux divers exemples.
;; L'objectif est cit aprs chaque combinaison de stimuli. Leurs pondrations
;; initiales tant alatoires, les perceptrons ne peuvent pas donner
;; satisfaction ds leur cration...

(performe pXOR       '(((-1 -1) -1)
                       ((-1  1)  1)
                       (( 1 -1)  1)
                       (( 1  1) -1)) :print t)
(performe pARB1    '(((-1 -1 -1) -1)
                     ((-1 -1  1)  1)
                     ((-1  1 -1) -1)
                     ((-1  1  1)  1)
                     (( 1 -1 -1) -1)
                     (( 1 -1  1) -1)
                     (( 1  1 -1)  1)
                     (( 1  1  1)  1)) :print t)
(performe pARB2 '(((-1 -1 -1 -1) -1)
                  ((-1 -1 -1  1) -1)
                  ((-1 -1  1 -1)  1)
                  ((-1 -1  1  1) -1)
                  ((-1  1 -1 -1)  1)
                  ((-1  1 -1  1)  1)
                  ((-1  1  1 -1)  1)
                  ((-1  1  1  1)  1)
                  (( 1 -1 -1 -1) -1)
                  (( 1 -1 -1  1)  1)
                  (( 1 -1  1 -1) -1)
                  (( 1 -1  1  1) -1)
                  (( 1  1 -1 -1)  1)
                  (( 1  1 -1  1)  1)
                  (( 1  1  1 -1) -1)
                  (( 1  1  1  1)  1)) :print t)

;;   Evaluer manuellement parmi les formes ci-dessous, au besoin...

;(Ws? pXOR) (Ws? pARB1) (Ws? pARB2)

;(tire pXOR '(-1 -1)) (tire pXOR '(-1  1)) (tire pXOR '( 1 -1)) (tire pXOR '( 1  1))
;(tire pARB1 '(-1 -1  1)) (tire pARB1 '(-1  1 -1))
;    (tire pARB1 '( 1  1 -1)) (tire pARB1 '( 1  -1  1))
;(tire pARB2 '(-1 -1  1 -1)) (tire pARB2 '(-1  -1  1 -1))
;    (tire pARB2 '( 1  1  1 -1)) (tire pARB2 '(-1  1  -1  1))

;;   Demander poliment aux perceptrons de faire leur apprentissage... 

;(apprend pXOR  '(((-1 -1) -1) ((-1  1)  1) (( 1 -1)  1) (( 1  1) -1)))
;(apprend pARB1 '(((-1 -1 -1) -1) ((-1 -1  1)  1) ((-1  1 -1) -1) ((-1  1  1)  1) (( 1 -1 -1) -1) (( 1 -1  1) -1) (( 1  1 -1)  1) (( 1  1  1)  1)))
;(apprend pARB2 '(((-1 -1 -1 -1) -1) ((-1 -1 -1  1) -1) ((-1 -1  1 -1)  1) ((-1 -1  1  1) -1) ((-1  1 -1 -1)  1) ((-1  1 -1  1)  1) ((-1  1  1 -1)  1) ((-1  1  1  1)  1) (( 1 -1 -1 -1) -1) (( 1 -1 -1  1)  1) (( 1 -1  1 -1) -1) (( 1 -1  1  1) -1) (( 1  1 -1 -1)  1) (( 1  1 -1  1)  1) (( 1  1  1 -1) -1) (( 1  1  1  1)  1)))
 
;;   Rvaluer ensuite les mthodes performe d'impression ci-dessus...

;;   Les perceptrons seront incapables de reproduire tous les exemples :
;; l'apprentissage ne se terminera jamais...

;;   La mthode meilleure-performance permettra cependant de restituer la
;; meilleure performance obtenue en cours d'apprentissage.
;;   Il s'agit en fait des premires pondrations ayant permis d'obtenir le
;; meilleur nombre de ractions correctes, parfois suprieur, mais pas
;; ncessairement,  celui ralis au moment de l'interruption de
;; l'apprentissage.

;(bestWs?   pXOR) (bestWs?   pARB1) (bestWs?   pARB2)
;(bestPerf? pXOR) (bestPerf? pARB1) (bestPerf? pARB2)

;(meilleure-performance  pXOR)
;(meilleure-performance pARB1) (meilleure-performance pARB2)

;;   Dans de tels cas, il est possible de minimiser l'erreur avec une unit
;; linaire et la rgle de correction *Gradient Descent* (*linear units*,
;; *Gradient Descent and the Delta Rule*, cf. [MITCHELL, op. cit. : 89 sq.]).
;;   Rien n'assure cependant que le nombre de ractions correctes en sera
;; augment [op. cit. : 94]. L'apprentissage n'en sera donc pas ncessairement
;; mieux russi.
