;;   Le fichier ann.01.CLOS doit avoir t charg pralablement.

;;; Exemples d'oprations logiques lmentaires  deux oprandes, constituant
;;; toutes des cas *linairement sparables*

;;   Charger ce fichier, puis valuer manuellement parmi les dernires lignes...

;;   Dfinition de quatre instances de perceptrons, destines  reproduire les
;; quatre oprations logiques de base.

(setq pAND  (make-instance 'perceptron :nom "pAND"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 3)))
(setq pNAND (make-instance 'perceptron :nom "pNAND"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 3)))
(setq pOR   (make-instance 'perceptron :nom "pOR"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 3)))
(setq pNOR  (make-instance 'perceptron :nom "pNOR"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 3)))

;;   Dfinition de deux instances de perceptrons, destines  produire des
;; constantes logiques "tout ou rien". Cf. tautologie et contradiction
;; [Wittgenstein, 1961(1922) : <Tractatus logico-philosophicus> : 62-63] :
;; rsultats toujours identiques, quels que soient les stimuli.

(setq pTOUT (make-instance 'perceptron :nom "pTOUT"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 3)))
(setq pRIEN (make-instance 'perceptron :nom "pRIEN"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 3)))

;;   Impression des performances des perceptrons aux divers exemples.
;; L'objectif est cit aprs chaque combinaison de stimuli. Leurs pondrations
;; initiales tant alatoires, les perceptrons ne peuvent pas donner
;; satisfaction ds leur cration...

(performe pAND  '(((-1 -1) -1)
                  ((-1  1) -1)
                  (( 1 -1) -1)
                  (( 1  1)  1)) :print t)
(performe pNAND '(((-1 -1)  1)
                  ((-1  1)  1)
                  (( 1 -1)  1)
                  (( 1  1) -1)) :print t)
(performe pOR   '(((-1 -1) -1)
                  ((-1  1)  1)
                  (( 1 -1)  1)
                  (( 1  1)  1)) :print t)
(performe pNOR  '(((-1 -1)  1)
                  ((-1  1) -1)
                  (( 1 -1) -1)
                  (( 1  1) -1)) :print t)
(performe pTOUT '(((-1 -1)  1)
                  ((-1  1)  1)
                  (( 1 -1)  1)
                  (( 1  1)  1)) :print t)
(performe pRIEN '(((-1 -1) -1)
                  ((-1  1) -1)
                  (( 1 -1) -1)
                  (( 1  1) -1)) :print t)

;;   Evaluer manuellement parmi les formes ci-dessous, au besoin...

;(Ws? pAND) (Ws? pNAND) (Ws? pOR) (Ws? pNOR) (Ws? pTOUT) (Ws? pRIEN)

;(tire pAND  '(-1 -1)) (tire pAND  '(-1  1)) (tire pAND  '( 1 -1)) (tire pAND  '( 1  1))
;(tire pNAND '(-1 -1)) (tire pNAND '( 1  1)) (tire pNAND '( 1 -1)) (tire pNAND '( 1  1))
;(tire pOR   '(-1 -1)) (tire pOR   '(-1  1)) (tire pOR   '( 1 -1)) (tire pOR   '( 1  1))
;(tire pNOR  '(-1 -1)) (tire pNOR  '(-1  1)) (tire pNOR  '( 1 -1)) (tire pNOR  '( 1  1))
;(tire pTOUT '(-1 -1)) (tire pTOUT '(-1  1)) (tire pTOUT '( 1 -1)) (tire pTOUT '( 1  1))
;(tire pRIEN '(-1 -1)) (tire pRIEN '(-1  1)) (tire pRIEN '( 1 -1)) (tire pRIEN '( 1  1))

;;   Demander poliment aux perceptrons de faire leur apprentissage...

;(apprend pAND  '(((-1 -1) -1) ((-1  1) -1) (( 1 -1) -1) (( 1  1)  1)))
;(apprend pNAND '(((-1 -1)  1) ((-1  1)  1) (( 1 -1)  1) (( 1  1) -1)))
;(apprend pOR   '(((-1 -1) -1) ((-1  1)  1) (( 1 -1)  1) (( 1  1)  1)))
;(apprend pNOR  '(((-1 -1)  1) ((-1  1) -1) (( 1 -1) -1) (( 1  1) -1)))
;(apprend pTOUT '(((-1 -1)  1) ((-1  1)  1) (( 1 -1)  1) (( 1  1)  1)))
;(apprend pRIEN '(((-1 -1) -1) ((-1  1) -1) (( 1 -1) -1) (( 1  1) -1)))

;;   Rvaluer ensuite les mthodes performe d'impression ci-dessus...
