;		FREQUENCY SHIFTER 1 et 2 	[   O R C H E S T R A   ]
;------------------------------------------------------------------------------
;	APPLICATION SUR UN SPECTRE SYNTHETIQUE ou un SON PRE-ENREGISTRE
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 44100				; taux d'ech. audio : 44100
	kr = 8820				; taux d'ech. controle : 8820
	ksmps = 5				; = sr/kr 
	nchnls = 1				; "mono"

; instrument auxiliaire, pour ecoute du spectre original (f3) et de la
; frequence de modulation (sinus f1)
	instr 2
		kenv	oscil1i 0,ampdb(90+p4),p3, 2
		aout	oscili	kenv,p5, p6
			out	aout
	endin

; instrument auxiliaire, pour ecoute du son pre-enregistre original
	instr 3
		a1	soundin	p4		; voix = fichier soundin.1
			out	a1
	endin

; instrument 5 :	a pour fonction de fournir les echantillons a moduler,
;					dans la variable "gatobe"
;		Programmation generale (PEU EFFICACE), pour fins pedagogiques :
;			cas1 : p4>0  ==> lira le fichier "soundin.(p4)"
;			cas2 : p4<=0 ==> sortira le spectre p6, sous enveloppe
;					 p7, avec intensite p4 et frequence p5
	instr 5
		if	p4 > 0 goto cas1
		cas2:	kenv	oscil1i	0,ampdb(90+p4),p3, p7	; env. p7
			ain	oscili kenv,p5, p6		; spect. p6
			goto fin
		cas1:	ain	soundin p4			; lecture brute
		fin:	gatobe = ain
	endin

; instrument 6 :	recoit les echantillons dans "gatobe", et effectue les
;					modulations dans "gaoutn" et "gaoutp"
;		p4 :	no. table d'onde de modulation
;		p5 :	freqence de modulation
; N.B. : coefficients et circuits de filtres corriges (optimises) par rapport
; a l'original 4X : des coefficients sont remplaces par "1 - leur valeur"
; (de icoa3 a icob3). En consequence : les calculs les impliquant sont modifies
; et la variable "atmp" est eliminee. Tous les etages de filtres sont donc
; rediges de la meme maniere.
	instr 6
		; initialisations
			aouta1	init 0.0	;sorties des etages filtre a
			aouta2	init 0.0
			aouta3	init 0.0
			aouta4	init 0.0
			aoutb1	init 0.0	;sorties des etages filtre b
			aoutb2	init 0.0
			aoutb3	init 0.0
			aoutb4	init 0.0
			areta1	init 0.0	;ret. cascade "z**(-1)" filt. a
			areta2	init 0.0
			areta3	init 0.0
			areta4	init 0.0
			aretb1	init 0.0	;ret. cascade "z**(-1)" filt. b
			aretb2	init 0.0
			aretb3	init 0.0
			aretb4	init 0.0
			icoa1	= -0.5234	;coefficients filtre a
			icoa2	= 0.49771
			icoa3	= 0.88803
			icoa4	= 0.98047
			icob1	= 0.99480	;coefficients filtre b
			icob2	= 0.95152
			icob3	= 0.75363
			icob4	= 0.08411
		; filtre a
			aouta1	= ((aouta1-gatobe)*icoa1)+areta1
			areta1	= gatobe
			aouta2	= ((aouta2-aouta1)*icoa2)+areta2
			areta2	= aouta1
			aouta3	= ((aouta3-aouta2)*icoa3)+areta3
			areta3	= aouta2
			aouta4	= ((aouta4-aouta3)*icoa4)+areta4
			areta4	= aouta3
		; filtre b
			aoutb1	= ((aoutb1-gatobe)*icob1)+aretb1
			aretb1	= gatobe
			aoutb2	= ((aoutb2-aoutb1)*icob2)+aretb2
			aretb2	= aoutb1
			aoutb3	= ((aoutb3-aoutb2)*icob3)+aretb3
			aretb3	= aoutb2
			aoutb4	= ((aoutb4-aoutb3)*icob4)+aretb4
			aretb4	= aoutb3
		; oscillateurs sin et cos de la frequence de modulation
			asinus	oscili 1.0,p5, p4, 0.00
			acosin	oscili 1.0,p5, p4, 0.25
		; modulation et assignation aux variables globales de sortie
			aa	= asinus*aouta4
			ab	= acosin*aoutb4
			gaoutn	= aa-ab			; modulation inferieure
			gaoutp	= aa+ab			; modulation superieure
	endin

; instrument 7 :	recoit et sort la modulation inferieure "gaoutn"
;		Configuration generale (PEU EFFICACE), pour fins pedagogiques
	instr 7
			out gaoutn
	endin

; instrument 8 :	recoit et sort la modulation superieure "gaoutp"
;		Configuration generale (PEU EFFICACE), pour fins pedagogiques
	instr 8
			out gaoutp
	endin
